package gov.va.med.mhv.health.validator;

import gov.va.med.mhv.health.dto.ImmunizationDTO;
import gov.va.med.mhv.health.dto.ImmunizationReactionDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.enums.OtherSymptomEnumeration;
import gov.va.med.mhv.health.enums.ReactionsEnumeration;
import gov.va.med.mhv.health.enums.VaccinationMethodEnumeration;
import gov.va.med.mhv.health.util.MessagesUtil;

import java.util.Date;
import java.util.Iterator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImmunizationValidator extends Validator{
	
	private static final int COMMENTS_MAX_LENGTH = 255;
	private static final int VACCINETYPECODE_MAX_LENGTH = 6;
	private static final int OTHERVACCINE_MAX_LENGTH = 100;
	private static final String VACCINATION_METHOD="Vaccination Method";
	private static final String DATE_RECEIVED="Date Received";
	private static final String COMMENTS="Comments";
	private static final String VACCINATION_TYPE_CD="Vaccination Type Code";
	private static final String OTHER_VACCINE="Other Vaccine";
	private static final String REACTION_TYPE_CD="Reaction Type Code";
	private static final String IMMUNIZATION="Immunization";
	
	@Autowired
	private MessagesUtil messages;
	
	public void immunizationValidations(ResponseUtil response, ImmunizationDTO imdto) {
		fieldValidation(response, imdto);
	}

	private void fieldValidation(ResponseUtil response, ImmunizationDTO imdto) {
		validateImmunization(response, imdto);
		validateDateReceived(response,imdto);
		validateComments(response,imdto);
		validateVaccinationMethod(response,imdto);
		validateOtherVaccine(response,imdto);
		validateReactionTypeCode(response,imdto);
		if(imdto.getReactions() != null){
			for(Iterator<ImmunizationReactionDTO> it = imdto.getReactions().iterator();it.hasNext();){
				ImmunizationReactionDTO reactionDTO =it.next();
				validateReactionCode(response,reactionDTO);
				
			}
	    }
		validateUserProfile(response,imdto);
	}
	
	private void validateImmunization(ResponseUtil response, ImmunizationDTO imdto) {
		if (imdto.getVaccinationTypeCode() == null) {
			response.getValidationErrors().put(IMMUNIZATION, "Immunization is a required field.");

		}
	}

	private void validateUserProfile(ResponseUtil response,	ImmunizationDTO imdto) {
		if( imdto.getUserprofileId() == null ) {
			response.getValidationErrors().put("userProfile", "userProfile is required");
			return;
		}
		boolean valid= isUserProfileValid(imdto.getUserprofileId());
		if ( !valid) {
			response.getValidationErrors().put("userProfile", "userProfile is Invalid");
		}
		
	}

	private void validateReactionCode(ResponseUtil response,ImmunizationReactionDTO reactionDTO) {
		
		String value = reactionDTO.getReactionTypeCode();
		if( value == null ) {
			return;
		}		
		Validations.validateEnumeration(REACTION_TYPE_CD, value, ReactionsEnumeration.values(), response.getValidationErrors());
		
	}

	private void validateReactionTypeCode(ResponseUtil response,ImmunizationDTO imdto) {
		
		String value = imdto.getReactionTypeCode();
		if( value == null ) {
			return;
		}		
		Validations.validateEnumeration(REACTION_TYPE_CD, value, OtherSymptomEnumeration.values(), response.getValidationErrors());
	}

	private void validateOtherVaccine(ResponseUtil response,ImmunizationDTO imdto) {
		
		String value = imdto.getOtherVaccine();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength(OTHER_VACCINE,value, OTHERVACCINE_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateVaccineTypeCode(ResponseUtil response, ImmunizationDTO imdto) {
		String value = imdto.getVaccinationTypeCode();
		if ( value == null ) {
			Validations.validateRequired(VACCINATION_TYPE_CD, value, response.getValidationErrors());
			return;
		}						
		Validations.validateMaxLength(VACCINATION_TYPE_CD,value, VACCINETYPECODE_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateVaccinationMethod(ResponseUtil response,ImmunizationDTO imdto) {
		String value = imdto.getVaccinationMethod();
		if( value == null ) {
			return;
		}		
		Validations.validateEnumeration(VACCINATION_METHOD, value, VaccinationMethodEnumeration.values(), response.getValidationErrors());
	}

	private void validateComments(ResponseUtil response, ImmunizationDTO imdto) {
		String value = imdto.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength(COMMENTS,value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateDateReceived(ResponseUtil response,ImmunizationDTO imdto) {
		Date value = imdto.getDateReceived();
		if( value == null ) {
			Validations.validateRequired(DATE_RECEIVED, value, response.getValidationErrors());
			return;
		}		
	}
}
